/*
 * Decompiled with CFR 0.152.
 */
package org.instituteofthefuture.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLDocument;
import org.instituteofthefuture.gui.Alerts;
import org.instituteofthefuture.io.FileUtilities;

public class TextViewerFrame
extends JFrame {
    public static boolean DEBUG = false;
    private String fileName;
    private JTextPane jtpText;

    private final void setupInterface() {
        this.jtpText = new JTextPane();
        this.jtpText.setEditable(false);
        this.jtpText.setOpaque(false);
        JScrollPane jScrollPane = new JScrollPane(this.jtpText);
        jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.fileName), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        jScrollPane.setOpaque(false);
        this.setTitle("Viewing " + this.fileName);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jScrollPane, "Center");
        this.setBounds(20, 20, 500, 400);
        this.setVisible(true);
    }

    private final void load(File file) {
        try {
            this.fileName = file.getName();
            this.load(new FileInputStream(file));
        }
        catch (Exception exception) {
            this.output(exception.toString());
            exception.printStackTrace();
            Alerts.showError("Error", exception.toString());
        }
    }

    private final void load(InputStream inputStream) {
        try {
            this.jtpText.setContentType("text/html");
            this.jtpText.read(inputStream, (Object)new HTMLDocument());
        }
        catch (Exception exception) {
            this.output(exception.toString());
            exception.printStackTrace();
            Alerts.showError("Error", exception.toString());
        }
    }

    private final void output(String string) {
        if (DEBUG) {
            System.out.println(string);
        }
    }

    public static void main(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < 100) {
            vector.addElement("line " + n);
            ++n;
        }
        TextViewerFrame textViewerFrame = new TextViewerFrame("Example", vector);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TextViewerFrame(String string, boolean bl) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            try {
                if (bl) {
                    this.fileName = string;
                    this.load(FileUtilities.getInputStreamFromResource(string));
                } else {
                    this.load(new File(string));
                }
                this.setupInterface();
            }
            catch (Exception exception) {
                this.output(exception.toString());
                exception.printStackTrace();
                Alerts.showError("Error", exception.toString());
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.setCursor(Cursor.getPredefinedCursor(0));
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public TextViewerFrame(String string, Vector vector) {
        this.fileName = string;
        this.setupInterface();
        String string2 = "";
        int n = 0;
        while (n < vector.size()) {
            string2 = string2 + vector.elementAt(n) + " \n";
            ++n;
        }
        this.jtpText.setText(string2);
    }
}

