/*
 * Decompiled with CFR 0.152.
 */
package org.instituteofthefuture.exif;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JTextField;
import org.instituteofthefuture.exif.EOMConstants;
import org.instituteofthefuture.exif.EOMMenuBar;
import org.instituteofthefuture.exif.EOMPrefs;
import org.instituteofthefuture.exif.ExifInfoPanel;
import org.instituteofthefuture.exif.ExifInfoWriter;
import org.instituteofthefuture.exif.PrefsDialog;
import org.instituteofthefuture.exif.SaveDialog;
import org.instituteofthefuture.gui.AboutDialog;
import org.instituteofthefuture.gui.GUIUtilities;
import org.instituteofthefuture.io.ImageUtilities;

public class ExifOMatic
extends JFrame
implements EOMConstants {
    public static JTextField status = new JTextField("choose File->Open to get started");
    private EOMMenuBar myMenuBar;
    private ExifInfoPanel myInfoPanel;

    public void open() {
        ExifInfoPanel exifInfoPanel = new ExifInfoPanel(this);
        if (exifInfoPanel.failed) {
            return;
        }
        this.loadInfoPanel(exifInfoPanel);
    }

    public boolean openFile(File file) {
        if (!file.exists()) {
            return false;
        }
        ExifInfoPanel exifInfoPanel = new ExifInfoPanel(this, file);
        this.loadInfoPanel(exifInfoPanel);
        return true;
    }

    private final void loadInfoPanel(ExifInfoPanel exifInfoPanel) {
        if (this.myInfoPanel != null) {
            this.remove(this.myInfoPanel);
        }
        this.myInfoPanel = exifInfoPanel;
        this.getContentPane().add((Component)this.myInfoPanel, "Center");
        this.myMenuBar.setEnabled("Export...", true);
        this.myMenuBar.setEnabled("Close", true);
        this.validate();
    }

    public void close() {
        if (this.myInfoPanel != null) {
            this.remove(this.myInfoPanel);
            this.myInfoPanel = null;
            this.validate();
        }
        this.myMenuBar.setEnabled("Export...", true);
        this.myMenuBar.setEnabled("Close", true);
        this.setTitle("EXIF-O-Matic");
        ExifOMatic.setStatus("image closed, choose File->Open to get started");
    }

    public void export() {
        this.myInfoPanel.writeInfoFile();
    }

    public void showPrefsDialog() {
        PrefsDialog prefsDialog = new PrefsDialog(this);
        prefsDialog.show();
    }

    public void processFolder() {
        if (this.myInfoPanel == null) {
            ExifInfoWriter exifInfoWriter = new ExifInfoWriter();
            exifInfoWriter.selectFile();
            SaveDialog saveDialog = new SaveDialog(this);
            if (saveDialog.okToSave()) {
                if (saveDialog.getHTML()) {
                    exifInfoWriter.writeInfoForFolder(0);
                } else {
                    exifInfoWriter.writeInfoForFolder(1);
                }
            }
        } else {
            this.myInfoPanel.processFolder();
        }
    }

    public boolean processFolder(File file) {
        if (!file.exists()) {
            return false;
        }
        ExifInfoWriter exifInfoWriter = new ExifInfoWriter();
        exifInfoWriter.writeInfoForFolder(file, 0);
        return true;
    }

    public void about() {
        AboutDialog aboutDialog = new AboutDialog(this, "EXIF-O-Matic", "1.1.8", "http://www.instituteofthefuture.org/exifomatic/", ImageUtilities.getImageIconFromResource("exificon.jpg"));
    }

    public void exit() {
        EOMPrefs.store();
        this.setVisible(false);
        this.dispose();
        System.exit(0);
    }

    public static void setStatus(String string) {
        status.setText("> " + string);
    }

    public static void main(String[] stringArray) {
        ExifOMatic exifOMatic = new ExifOMatic();
    }

    public ExifOMatic() {
        super("EXIF-O-Matic");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ ExifOMatic this$0;

            public final void windowClosing(WindowEvent windowEvent) {
                this.this$0.exit();
            }
            {
                this.this$0 = exifOMatic;
            }
        });
        EOMPrefs.load();
        this.myMenuBar = new EOMMenuBar(this);
        this.setJMenuBar(this.myMenuBar);
        status.setFont(new Font("SanSerif", 0, 10));
        status.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        status.setForeground(new Color(51, 51, 80));
        status.setEditable(false);
        status.setOpaque(false);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)status, "South");
        GUIUtilities.setNativeLookAndFeel();
        GUIUtilities.setFrameSize(this, 710, 455);
        this.setResizable(true);
        this.setVisible(true);
    }
}

