/*
 * Decompiled with CFR 0.152.
 */
package org.instituteofthefuture.exif;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.instituteofthefuture.IFConstants;
import org.instituteofthefuture.exif.ExifInfoWriter;
import org.instituteofthefuture.exif.SaveDialog;
import org.instituteofthefuture.gui.GUIUtilities;
import org.instituteofthefuture.gui.ImageBorder;
import org.instituteofthefuture.io.ImageUtilities;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ExifInfoPanel
extends JPanel
implements ActionListener,
IFConstants {
    private static boolean DEBUG = false;
    private ExifInfoWriter myExifWriter;
    public boolean failed;
    private JFrame parent;

    private final void setupInterface() {
        JPanel jPanel;
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 5, 10));
        JLabel jLabel = new JLabel(this.myExifWriter.getSelectedFileName(), 0);
        jLabel.setFont(new Font("Serif", 0, 20));
        ImageIcon imageIcon = new ImageIcon(this.myExifWriter.getSelectedFile().toString());
        ImageUtilities.resizeTo(imageIcon, 200);
        JLabel jLabel2 = new JLabel(imageIcon);
        if (IFConstants.isMacOSX) {
            jPanel = ImageBorder.getOSXImageWellPanel(jLabel2);
        } else {
            jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)jLabel2, "Center");
        }
        jPanel.setPreferredSize(new Dimension(225, 225));
        JButton jButton = new JButton("Export Info File");
        jButton.addActionListener(this);
        jButton.setBounds(30, 270, 180, 26);
        JButton jButton2 = new JButton("Process this Folder");
        jButton2.addActionListener(this);
        jButton2.setBounds(30, 300, 180, 26);
        jPanel2.add(jPanel);
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel2.setMinimumSize(new Dimension(260, 330));
        jPanel2.setPreferredSize(new Dimension(260, 330));
        Object[] objectArray = new String[]{"Tag Name", "Tag Value"};
        ExifInfoPanel.output("about to get tags...");
        Object[][] objectArray2 = this.myExifWriter.getTagsAsObjectArray();
        if (objectArray2 == null) {
            this.failed = true;
            return;
        }
        ExifInfoPanel.output("got (" + objectArray2.length + ") tags...");
        JTable jTable = new JTable(objectArray2, objectArray);
        GUIUtilities.setCellEditable(jTable, false);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setMinimumSize(new Dimension(350, 330));
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(700, 450));
        this.add((Component)jPanel2, "West");
        this.add((Component)jScrollPane, "Center");
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.setVisible(true);
        this.parent.setTitle("EXIF-O-Matic : " + jLabel.getText());
    }

    public void processFolder() {
        SaveDialog saveDialog = new SaveDialog(this.parent);
        if (saveDialog.okToSave()) {
            if (saveDialog.getHTML()) {
                this.myExifWriter.writeInfoForFolder(0);
            } else {
                this.myExifWriter.writeInfoForFolder(1);
            }
        }
    }

    public void writeInfoFile() {
        SaveDialog saveDialog = new SaveDialog(this.parent);
        if (saveDialog.okToSave()) {
            if (saveDialog.getHTML()) {
                this.myExifWriter.writeInfoForImage(0);
            } else {
                this.myExifWriter.writeInfoForImage(1);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof JButton) {
            if (((JButton)object).getText().equals("Export Info File")) {
                this.writeInfoFile();
            } else if (((JButton)object).getText().equals("Process this Folder")) {
                this.processFolder();
            }
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Exif Info Panel");
        jFrame.getContentPane().add(new ExifInfoPanel(jFrame));
        jFrame.setBounds(10, 10, 700, 450);
        jFrame.setVisible(true);
    }

    public static void output(String string) {
        if (DEBUG) {
            System.out.println(" ExifInfoPanel : " + string);
        }
    }

    private final /* synthetic */ void this() {
        this.failed = false;
    }

    public ExifInfoPanel(JFrame jFrame, File file) {
        this.this();
        this.parent = jFrame;
        this.myExifWriter = new ExifInfoWriter();
        this.myExifWriter.setFile(file);
        this.setupInterface();
    }

    public ExifInfoPanel(JFrame jFrame) {
        this.this();
        this.parent = jFrame;
        this.myExifWriter = new ExifInfoWriter();
        if (this.myExifWriter.selectFile() == null) {
            this.failed = true;
            return;
        }
        this.setupInterface();
    }
}

